declare default element namespace 'http://пф.рф/ВС/СЗВ-М/2016-01-01';declare namespace УТ = "http://пф.рф/унифицированныеТипы/2014-01-01";
declare namespace АФ = "http://пф.рф/АФ";
declare variable $document as node()* external;
declare variable $root:=root($document)/ЭДПФР;
declare variable $szv:=$root/СЗВ-М;
declare variable $snArray:=$szv//СНИЛС;
declare variable $innArray:=$szv//ИНН;
declare variable $kppArray:=$szv//КПП;
declare function local:nodeIndex($nodes as node()*, $nodeToFind as node()) as xs:integer
{
for $seq in (1 to count($nodes))
				return $seq[$nodes[$seq] is $nodeToFind]
};
declare function local:nodePosition($node as node()?) as xs:string
{

				string-join(
						for $ancestor in $node/ancestor-or-self::*
						let $sibsOfSameName := $ancestor/../*[name()=name($ancestor)]
						return concat(name($ancestor),
							if (count($sibsOfSameName) <= 1) then '' else concat('[',local:nodeIndex($sibsOfSameName,$ancestor),']')),
							'/'
					)
			
};
declare function local:chars($arg as xs:string?) as xs:string*
{

				for $ch in string-to-codepoints($arg)
				return codepoints-to-string($ch)
			
};
declare function local:leaf-elements($root as node()?) as element()*
{
$root/descendant-or-self::*[not(*)]
};
declare function local:trim($str as xs:string?) as xs:string
{
replace(replace($str,'\s+$',''),'^\s+','')
};
<БлокПроверок ID="ВСЗЛ.ОП.1" name="Общие для всех документов правила проверки">
<Проверка ID="1">
<Описание>Последние 2 цифры Страхового номера должны быть числом, подсчитанным по Алгоритму формирование контрольного числа Страхового номера</Описание>
<РезультатЗапроса>
{
				if (count($snArray) > 0) then
					for $item in $snArray
						let $sn := translate($item,'- ','')
						let $cs := xs:integer(substring($sn,10))
						let $seqSn := local:chars(substring($sn,1,9))
						let $cnt := count($seqSn)
						let $summ := sum(
							for $i in 1 to $cnt
							return ($cnt + 1 - $i) * xs:integer($seqSn[$i]))
						return if ($summ < 100) then
							if ($cs = $summ) then '0' else local:nodePosition($item)
						else if ($summ = (100, 101)) then
							if ($cs = 0) then '0' else local:nodePosition($item)
						else
							let $rest := $summ mod 101
							return if ($rest < 100) then
								if ($cs = $rest) then '0' else local:nodePosition($item)
							else if ($cs = 0) then '0' else local:nodePosition($item)
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>30</КодРезультата>
</Проверка>
<Проверка ID="2">
<Описание>Значение элемента ИНН не должно состоять из одних нулей</Описание>
<РезультатЗапроса>
{
				if (count($innArray) > 0) then
					for $item in $innArray
						return if (translate($item,'0','') = '') then local:nodePosition($item) else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>30</КодРезультата>
</Проверка>
<Проверка ID="3">
<Описание>Значение элемента КПП должно быть ненулевым</Описание>
<РезультатЗапроса>
{
				if (count($kppArray) > 0) then
					for $item in $kppArray
						return if (translate($item,'0','') = '') then local:nodePosition($item) else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>10</КодРезультата>
</Проверка>
<Проверка ID="4">
<Описание>Контрольные цифры ИНН должны быть числом, подсчитанным по Алгоритму формирование контрольного числа ИНН</Описание>
<РезультатЗапроса>
{
				if (count($innArray) > 0) then
					for $inn in $innArray
						return if (string-length($inn) = 12 and substring($inn,11) != '--') then
							let $n1 := xs:integer(substring($inn,11,1))
							let $n2 := xs:integer(substring($inn,12,1))
							let $koef1 := (7,2,4,10,3,5,9,4,6,8)
							let $koef2 := (3,7,2,4,10,3,5,9,4,6,8)
							let $inn10 := local:chars(substring($inn,1,10))
							let $inn11 := local:chars(substring($inn,1,11))
							let $s1 := sum(
								for $i in 1 to 10
								return $koef1[$i] * xs:integer($inn10[$i])
							)
							let $s2 := sum(
								for $i in 1 to 11
								return $koef2[$i] * xs:integer($inn11[$i])
							)
							return if ($s1 mod 11 = $n1 and $s2 mod 11 = $n2) then '0' else local:nodePosition($inn)
						else
							let $n := xs:integer(substring($inn,10,1))
							let $koef := (2,4,10,3,5,9,4,6,8)
							let $inn9 := local:chars(substring($inn,1,9))
							let $s := sum(
								for $i in 1 to 9
								return $koef[$i] * xs:integer($inn9[$i])
							)
							return if ($s mod 11 = $n) then '0' else local:nodePosition($inn)
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>20</КодРезультата>
</Проверка>
<Проверка ID="6">
<Описание>Лидирующие пробелы в символьных элементах не допускаются</Описание>
<РезультатЗапроса>
{
				for $item in local:leaf-elements($root)
					return if (number($item) != number($item)) then
						if ($item = local:trim($item)) then '0'
						else local:nodePosition($item)
					else '0'
			}
</РезультатЗапроса>
<КодРезультата>40</КодРезультата>
</Проверка>
<Проверка ID="7">
<Описание>Если в символьном элементе использован символ '-', то рядом с этим символом пробелы недопустимы</Описание>
<РезультатЗапроса>
{
				for $item in local:leaf-elements($root)
					return if (number($item) != number($item)) then
						if (contains($item, ' -') or contains($item, '- ')) then local:nodePosition($item)
						else '0'
					else '0'
			}
</РезультатЗапроса>
<КодРезультата>40</КодРезультата>
</Проверка>
<Проверка ID="8">
<Описание>Наличие двух и более пробелов подряд внутри символьных элементов не допускается (только один)</Описание>
<РезультатЗапроса>
{
				for $item in local:leaf-elements($root)
					return if (number($item) != number($item)) then
						if (contains($item, '  ')) then local:nodePosition($item)
						else '0'
					else '0'
			}
</РезультатЗапроса>
<КодРезультата>40</КодРезультата>
</Проверка>
</БлокПроверок>

